<?php

class Image {

    private $imgID;
    private $title;
    private $descr;
    private $filename;

    private static $error;

    const MSG_ERROR_IMGID = 'IMGID doit être un entier';
    const MSG_ERROR_TITLE = 'TITLE doit être une chaîne de caractères';
    const MSG_ERROR_DESCR = 'DESCR doit être une chaîne de caractères';
    const MSG_ERROR_FILENAME = 'FILENAME doit être une chaîne de caractères';
    const MSG_ERROR_END = 'L\'objet ne peut pas être créé';

    public function __construct(array $data) {

        $this->setImgId($data['imgID']);
        $this->setTitle($data['title']);
        $this->setDescr($data['descr']);
        $this->setFilename($data['filename']);

        if(!empty(self::$error)) {

            throw new Exception(self::$error . self::MSG_ERROR_END);
        }
    }

    public function setError($msg) {

        self::$error = $msg;
    }

    public function getError() {

        return self::$error;
    }

    public function setImgId($imgID) {

        if((is_int($imgID)) AND ($imgID > 0)) {

            $this->imgID = $imgID;
        }
        else {

            $this->setError(self::MSG_ERROR_IMGID);
        }
    }

    public function setTitle($title) {

        if(is_string($title)) {

            $this->title = $title;
        }
        else {

            $this->setError(self::MSG_ERROR_TITLE);
        }
    }

    public function setDescr($descr) {

        if(is_string($descr)) {

            $this->descr = $descr;
        }
        else {

            $this->setError(self::MSG_ERROR_DESCR);
        }
    }

    public function setFilename($filename) {

        if(is_string($filename)) {

            $this->filename = $filename;
        }
        else {

            $this->setError(self::MSG_ERROR_FILENAME);
        }
    }

    public function getImgId() {

        return $this->imgID;
    }

    public function getTitle() {

        return $this->title;
    }

    public function getDescr() {

        return $this->descr;
    }

    public function getFilename() {

        return $this->filename;
    }
}