package opinion;

import java.util.LinkedList;

import exceptions.BadEntryException;
import exceptions.ItemBookAlreadyExistsException;
import exceptions.ItemFilmAlreadyExistsException;
import exceptions.MemberAlreadyExistsException;
import exceptions.NotItemException;
import exceptions.NotMemberException;

public class SocialNetwork implements ISocialNetwork {
	private LinkedList<Member> members ;
	private LinkedList<Review> reviews ;
	private LinkedList<Item> items;
	private LinkedList<Book> books;
	private LinkedList<Film> films;
	private int numberOfMembers ;
	private int numberOfFilms ;
	private int numberOfBooks ;
	public SocialNetwork() {
		this.members = new LinkedList<Member>() ;
		this.items = new LinkedList<Item>() ;
		this.films = new LinkedList<Film>() ;
		this.books = new LinkedList<Book>() ;
		this.numberOfMembers = 0 ;
		this.numberOfBooks = 0 ;
		this.numberOfFilms = 0 ;
	}
	@Override
	public int countNbMembers() {

		return numberOfMembers;
	}

	@Override
	public int countNbFilms() {
		
		return numberOfFilms;
	}

	@Override
	public int countNbBooks() {
		
		return numberOfBooks;
	}

	@Override
	public void addMember(String login, String password, String description)
			throws BadEntryException, MemberAlreadyExistsException {
		if (login==null || login.length()==0) {
			throw new BadEntryException("login non instancié");
		}
		if (login.trim().length()==0) {
			throw new BadEntryException("Pseudo ne contenant que des espaces ");
		}
		if (password==null || password.length()==0) {
			throw new BadEntryException("Password non instancié");
		}
		
		if (password.trim().length()<4) {
			throw new BadEntryException("Le password doit contenir au moins 4 caractères autre que des espaces en début et en fin ");
		}
		if (description==null) {
			throw new BadEntryException("La description non instanciée");
		}
		
		Member member = new Member(login,password,description);
		for (int i = 0 ; i < members.size() ; i++) {
			Member other_member = members.get(i) ;
			if (other_member.MemberLogin().toLowerCase().trim().equals( member.MemberLogin().toLowerCase().trim()) ){
				throw new MemberAlreadyExistsException();
			}
		}
		members.add(member);
		numberOfMembers = numberOfMembers + 1 ;
		
		
		
	}

	@Override
	public void addItemFilm(String login, String password, String title, String kind, String director, String scenarist,
			int duration) throws BadEntryException, NotMemberException, ItemFilmAlreadyExistsException {
		if (login==null || login.length()==0) {
			throw new BadEntryException("login non instancié");
		}
		if (login.trim().length()==0) {
			throw new BadEntryException("Pseudo ne contenant que des espaces ");
		}
		if (password==null || password.length()==0) {
			throw new BadEntryException("Password non instancié");
		}
		
		if (password.trim().length()<4) {
			throw new BadEntryException("Le password doit contenir au moins 4 caractères autre que des espaces en début et en fin ");
		}
		for (int i = 0 ; i < members.size() ; i++) {
			Member other_member = members.get(i) ;
			if (other_member.MemberLogin().toLowerCase().trim().equals(login.toLowerCase().trim()) ){
				if (other_member.MemberPassword().toLowerCase().trim().equals(password.toLowerCase().trim()) == false ) {
					throw new NotMemberException("password et login ne correspondent pas");
				}
				
			}
		}
		if (title==null || title.length()==0) {
			throw new BadEntryException("title non instancié");
		}
		if (title.trim().length()==0) {
			throw new BadEntryException("title ne contenant que des espaces ");
		}
		if (kind==null || kind.length()==0) {
			throw new BadEntryException("kind non instancié");
		}
		if (director==null || director.length()==0) {
			throw new BadEntryException("director non instancié");
		}
		if (scenarist==null || scenarist.length()==0) {
			throw new BadEntryException("scenarist non instancié");
		}
		if (duration <= 0) {
			throw new BadEntryException("duration inférieure ou égale à 0");
		}
		for (int i = 0 ; i < films.size() ; i++) {
			Film other_film = films.get(i) ;
			if (other_film.filmTitle(other_film).toLowerCase().trim().equals(title.toLowerCase().trim())) {
				throw new ItemFilmAlreadyExistsException();
			}
		}
		
		Film film = new Film(title,kind,director,scenarist,duration, null);
		films.add(film);
		items.add(film);
		numberOfFilms = numberOfFilms + 1 ;
		

		
		

	}

	@Override
	public void addItemBook(String login, String password, String title, String kind, String author, int nbPages)
			throws BadEntryException, NotMemberException, ItemBookAlreadyExistsException {
		if (login==null || login.length()==0) {
			throw new BadEntryException("login non instancié");
		}
		if (login.trim().length()==0) {
			throw new BadEntryException("Pseudo ne contenant que des espaces ");
		}
		if (password==null || password.length()==0) {
			throw new BadEntryException("Password non instancié");
		}
		
		if (password.trim().length()<4) {
			throw new BadEntryException("Le password doit contenir au moins 4 caractères autre que des espaces en début et en fin ");
		}
		for (int i = 0 ; i < members.size() ; i++) {
			Member other_member = members.get(i) ;
			if (other_member.MemberLogin().toLowerCase().trim().equals(login.toLowerCase().trim()) ){
				if (other_member.MemberPassword().toLowerCase().trim().equals(password.toLowerCase().trim()) == false ) {
					throw new NotMemberException("password et login ne correspondent pas");
				}
				
			}
		}
		if (title==null || title.length()==0) {
			throw new BadEntryException("title non instancié");
		}
		if (title.trim().length()==0) {
			throw new BadEntryException("title ne contenant que des espaces ");
		}
		if (kind==null || kind.length()==0) {
			throw new BadEntryException("kind non instancié");
		}
		if (author==null || author.length()==0) {
			throw new BadEntryException("author non instancié");
		}
		if (nbPages <= 0) {
			throw new BadEntryException("nbPages inférieur ou égal à 0");
		}
		for (int i = 0 ; i < books.size() ; i++) {
			Book other_book = books.get(i) ;
			if (other_book.bookTitle(other_book).toLowerCase().trim().equals(title.toLowerCase().trim())) {
				throw new ItemBookAlreadyExistsException();
			}
		}
		Book book = new Book(title,kind,author,nbPages,null);
		books.add(book);
		items.add(book);
		numberOfBooks = numberOfBooks + 1 ;
		
		
		
		
		
	}

	@Override
	public float reviewItemFilm(String login, String password, String title, float mark, String comment)
			throws BadEntryException, NotMemberException, NotItemException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public float reviewItemBook(String login, String password, String title, float mark, String comment)
			throws BadEntryException, NotMemberException, NotItemException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public LinkedList<String> consultItems(String title) throws BadEntryException {
	    if (title == null || title.length() == 0) {
	        throw new BadEntryException("Title non instancié");
	    }
	    if (title.trim().length() == 0) {
	        throw new BadEntryException("Title ne contient que des espaces");
	    }
	    if (items == null || items.size() == 0) {
	        return new LinkedList<>(); 
	    }

	    LinkedList<String> resultat = new LinkedList<>();

	    for (Item item : items) {
	        if (item.hasTitle(title)) {
	            if (item instanceof Book) {
	                Book book = (Book) item;
	           
	                resultat.add("Book: " + title + " with a score of: " + book.bhasScore());
	            } else if (item instanceof Film) {
	                Film film = (Film) item;
	     
	                resultat.add("Film: " + title + " with a score of: " + film.fhasScore());
	            }
	        }
	    }
	    return resultat;
	}

}
