;************************************************************************
;	                      Initialisation DS18B20                        *
;************************************************************************

InitDS18B20
		call	resetPresence
		movf	ds_return,F
		btfsc	STATUS,Z
	return								; resetPresence failed
		
		movlw	0xCC					; Skip ROM
		call	WriteTempByte
		movlw	0x4E					; Write Scratchpad
		call	WriteTempByte
		movlw	0x00					; Write TH
		call	WriteTempByte
		movlw	0x00					; Write TL
		call	WriteTempByte
		movlw	0x7F					; Write config du DS resolution de 12 Bits
		call	WriteTempByte

		movlw	.1
		movwf	ds_return
		
	return

;************************************************************************
;	                      Reset Presence	                            *
;************************************************************************

resetPresence
		Pin_hz
		movlw	.0
		movwf	ds_return

		Pin_low
		movlw	.50
		call	delay_10u				; attendre 500 s

		Pin_hz							; Haute impdance
		movlw	.6
		call	delay_10u				; attendre 60 s
		btfsc	DQ
	return								; Erreur si DQ=1

		movlw	.6
		call	delay_10u				; attendre 60 s
;
;		btfsc	DQ
;		return

		movlw	.36
		call	delay_10u				; attendre 360 s
	
		movlw	.1
		movwf	ds_return

	return

;************************************************************************
;		                      ReadTemp                               	*
;************************************************************************

ReadTemp
		call	resetPresence
		movf	ds_return,F
		btfsc	STATUS,Z
	return								; Erreur DS

		movlw	0xCC					; Skip ROM
		call	WriteTempByte

		movlw	0x44					; Demande de conversion/prise de temperature
		call	WriteTempByte

Ds_loop_read
		movlw	.100
		call	delay_1ms
		call	ReadTempBit
		btfss	ds_bit,0
		goto	Ds_loop_read			; Boucle tant que processus de lecture non termin


		call	resetPresence
		movf	ds_return,F
		btfsc	STATUS,Z
	return								; resetPresence failed

		movlw	0xCC					; Skip ROM
		call	WriteTempByte

		movlw	0xBE					; Read Scratchpad
		call	WriteTempByte
		
		call	ReadTempByte
		movf	ds_return,W
		movwf	Temp_Lsb				; Ecriture du poids faible

		call	ReadTempByte
		movf	ds_return,W
		movwf	Temp_Msb				; Ecriture du poids fort	
		
		call	resetPresence
		movf	ds_return,F

	return

;************************************************************************
;		                     ReadTempByte                               *
;************************************************************************

ReadTempByte
		movlw	.8
		movwf	ds_cmpt
DS_boucle_rot
		call	ReadTempBit
		rrf		ds_bit,F
		rrf		ds_return,F
		decfsz	ds_cmpt,F
		goto	DS_boucle_rot
		
	return

;************************************************************************
;		                      ReadTempBit                            	*
;************************************************************************

ReadTempBit
		Pin_low
		nop
		nop
		Pin_hz
		nop
		nop
		nop
		nop
		nop
		nop								; 8s en plus
		
		movf	PORTA,W
		movwf	ds_bit

		movlw	.6
		call	delay_10u
		
	return

;************************************************************************
;		                     WriteTempByte                              *
;************************************************************************

WriteTempByte
		movwf	Out_Byte
		movlw	.8
		movwf	ds_cmpt
WriteTempByte_1
		rrf		Out_Byte,F
		btfss	STATUS,C
		goto	Write_0
		goto	Write_1
WriteTempByte_2
		decfsz	ds_cmpt,F
		goto	WriteTempByte_1
	return

Write_0
		Pin_low
		movlw	.6
		call	delay_10u
		Pin_hz
		goto	WriteTempByte_2

Write_1
		Pin_low
		nop
		Pin_hz
		movlw	.6
		call	delay_10u
		goto	WriteTempByte_2
		
		
;************************************************************************
;                  				ERREUR_DS		           				*
;************************************************************************

ERREUR_DS
		
		movlw	'N'
		call	LCD_Write_car

		movlw	'O'
		call	LCD_Write_car

		movlw	' '
		call	LCD_Write_car

		movlw	'D'
		call	LCD_Write_car

		movlw	'S'
		call	LCD_Write_car

		movlw	'.'
		call	LCD_Write_car

		bsf		LED

		movlw	.50
		call	delay_100ms

		bcf		LED

		goto	Main

		
