;************************************************************************
;                                                                     	*
;    NOM:				Enregistreur de Temprature, liaison HF			*
;    Date:				Avril 2003                            			*
;    Version:			1.0                                   			*
;    Circuit:			Emetteur										*
;    Auteurs:			JEUFFRAULT/BERRADA 								*	
;                                                                     	*
;************************************************************************
;                                                                     	*
;    Fichier requis: P16F870.inc                                       	*
;                    LCD_emetteur.inc                                 	*
;                    tempo.inc                                         	*
;                    DS18B20.inc 										*
;					 EEPROM.inc	                                      	*
;************************************************************************
;                                                                     	*
;    Notes:                                                           	*
;              Marche pour la premiere fois le 27/04/03                 *
;                                                                     	*
;                                                                     	*
;                                                                     	*
;************************************************************************


	LIST     	 p=16F870           	; Dfinition de processeur
	#include 	<p16F870.inc>       	; Dfinitions des constantes

	__CONFIG   _CP_OFF & _WDT_OFF & _PWRTE_OFF & _LVP_OFF & _BODEN_OFF & _CPD_OFF & _DEBUG_OFF & _XT_OSC

;	_CP_ON		Code protection ON : impossible de relire
;	_CP_OFF		Code protection OFF
;	_PWRTE_ON	Timer reset sur power on en service
;	_PWRTE_OFF	Timer reset hors-service

	ERRORLEVEL	-302					; Supprime le warning de BANK

;************************************************************************
;                              ASSIGNATIONS                          	*
;************************************************************************

Base_Temps_1		EQU	.1
Base_Temps_2		EQU	.2

Base_Temps_Big_1	EQU	.1
Base_Temps_Big_2	EQU	.2

;************************************************************************
;	                             DEFINE                                 *
;************************************************************************
;DS
#DEFINE DQ			PORTA,0				; Ligne open drain

;Afficheur
#DEFINE RS			PORTC,4				; Selection du registre afficheur
#DEFINE E			PORTC,5				; Enable
#DEFINE	LCD_DATA	PORTB				; Afficheur LCD

#DEFINE	LED			PORTA,1
#DEFINE	BOUTON		PORTB,0
#DEFINE	SELECTION_1	PORTB,1
#DEFINE	SELECTION_2	PORTB,2

;Emetteur
#DEFINE SORTIE_TX	PORTA,3				; Sortie Vers module emission TX

;************************************************************************
;	                             MACROS                              	*
;************************************************************************

BANK0	macro	
	bcf		STATUS,RP0
	bcf		STATUS,RP1
	endm

BANK1	macro	
	bsf		STATUS,RP0
	bcf		STATUS,RP1
	endm

BANK2	macro	
	bcf		STATUS,RP0
	bsf		STATUS,RP1
	endm

BANK3	macro	
	bsf		STATUS,RP0
	bsf		STATUS,RP1
	endm


Pin_low	macro
	BANK1
	bcf		DQ
	BANK0
	bcf		DQ
	endm

Pin_hz	macro
	BANK1
	bsf		DQ
	BANK0
	endm

;************************************************************************
;	                   DECLARATIONS DE VARIABLES                        *
;************************************************************************

	CBLOCK 0x20   						; dbut de la zone variables

							;valeurs de retour
	ds_return 			:1				; Zone de 1 byte, valeur de retour du DS
	ds_bit				:1
	Out_Byte			:1

							;compteurs	
	ds_cmpt				:1
	cmpt1				:1				
	cmpt2				:1
	cmpt3 				:1
	Cmpt_TX				:1
	
	Base_Temps			:1
	Base_Temps_Big		:1

	Cpt_Base_Temps		:1
	Cpt_Base_Temps_Big	:1
	
	num_mesure			:1

							;variable temporaire (LCD)
	temp				:1
	TX_Temp				:1

							;temperature
	Temp_Lsb 			:1				
	Temp_Msb 			:1
							;partie entiere
	Temp_diz 			:1		
	Temp_cent			:1
	Temp_unit 			:1
							;partie decimale
	dec					:1
	un_sur_2			:1
	un_sur_4			:1
	un_sur_8			:1
	un_sur_16			:1
        ENDC							; Fin de la zone   
        
 	CBLOCK 0x70							; Zone commune aux 4 banques
 	
 	Adresse_eeprom		:1

 		ENDC
 	                            

;************************************************************************
;	                      DEMARRAGE SUR RESET                           *
;************************************************************************

	org		0x000	 					; Adresse de dpart aprs reset
  		goto	Main					; Adresse 0: initialiser


;************************************************************************
;	                     ROUTINE INTERRUPTION                           *
;************************************************************************

	org 	0x004						; adresse d'interruption
	
		btfss	INTCON,INTF
		goto	int_timer
		goto	int_RB0
		
int_timer
		movf	Cpt_Base_Temps_Big,f
		btfsc	STATUS,Z
		goto	$+3
	
		decfsz	Cpt_Base_Temps_Big,f
		goto	fin_int_timer
	
	
		decfsz	Cpt_Base_Temps,f
		goto	fin_int_timer
		
		call	int_temp
		
		movf	Base_Temps,W
		movwf	Cpt_Base_Temps
		movf	Base_Temps_Big,W
		movwf	Cpt_Base_Temps_Big
		
fin_int_timer
		bcf		PIR1,TMR1IF
	retfie
	
int_RB0
		clrf	TMR1L
		clrf	TMR1H
		call	int_temp
		bcf		INTCON,INTF
	retfie


;************************************************************************
;	                       INITIALISATIONS DU PIC                       *
;************************************************************************

Init

		BANK0
	
		clrf	PORTA					; Sorties portA  0
	
		BANK1
	
		movlw	0x01					; PortA,0	en entre,  les autres en sorties		
		movwf	TRISA		
		
		movlw	0x06
		movwf	ADCON1					; entres sorties numriques
		
		movlw	0x07
		movwf	TRISB					; portB en sortie sauf RB0,RB1,RB2 en entre
	
		clrf	TRISC					; portC ..
		
		movlw	0xC0		 			; charger masque
		movwf	OPTION_REG				; initialiser registre option
	
		movlw	0x01					; Interruption sur Timer 1
		movwf	PIE1
		
		BANK0
		
		movlw	0x1E					; prediviseur par 2 pr Timer 1, Oscillateur externe ...
		btfsc	SELECTION_2
		movlw	0x3E					; prediviseur par 8 pr Timer 1, Oscillateur externe ...	
		movwf	T1CON
	
		movlw	0x50					; masque interruption
		movwf	INTCON					; charger interrupt control Interruptions sur RB0
		
		clrf	PIR1
	
		clrf	PORTB					; sorties portB  0
		clrf	PORTC					; sorties portC  0
	
				; Effacer RAM
				
		movlw	0x20					; initialisation pointeur
		movwf	FSR						; pointeur d'adressage indirec
Init1
		clrf	INDF					; effacer ram
		incf	FSR,f					; pointer sur suivant
		btfss	FSR,7					; tester si fin zone atteinte (>=7F)
		goto	Init1					; non, boucler
	
		BANK3
		
		bsf		EECON1,WREN				; Autoriser ecriture EEPROM
	
		BANK0
	
		clrf	Adresse_eeprom	
		clrf	num_mesure
		
		movlw	Base_Temps_2
		btfsc	SELECTION_1
		goto	fin_test
		btfss	SELECTION_2
		movlw	Base_Temps_1
fin_test
		movwf	Cpt_Base_Temps
		movwf	Base_Temps
		
		
		movlw	Base_Temps_Big_1
		btfss	SELECTION_1
		goto	fin_test_2
		btfsc	SELECTION_2
		movlw	Base_Temps_Big_2
fin_test_2
		movwf	Cpt_Base_Temps_Big
		movwf	Base_Temps_Big
		
		clrf	TMR1H
		clrf	TMR1L

		bsf	INTCON,GIE	; valider interruptions

		bsf		T1CON,0					; Timer1 ON   
	
	return

;************************************************************************
;	                      PROGRAMME PRINCIPAL                        	*
;************************************************************************

Main
		call	Init					; Initialisation PIC
		call	LCD_Init				; Initialisation LCD 4 bits
Main1
		sleep							; MODE SLEEP
		nop
		goto	Main1


int_temp
		call	InitDS18B20				; Initialisation DS18B20
		movf	ds_return,F
		btfsc	STATUS,Z
		goto	ERREUR_DS				; Erreur

		bsf		LED

		call	ReadTemp				; Lecture de la temperature
		movf	ds_return,F
		btfsc	STATUS,Z
		goto	ERREUR_DS				; Erreur
	
		bcf		LED

		call	Write_Temp_eeprom
		btfsc	Adresse_eeprom,6		; on revient au debut si on a deja ecrit 64 octets
		clrf	Adresse_eeprom
		
		call	Send_temp

		call	Affich_Temp				;Affichage de la temprature sur le LCD
		
		incf	num_mesure,f
		movf	num_mesure,W
		
		call	Affich_nb_mesure

	return



		include		<LCD_emetteur.inc>
		include		<DS18B20.inc>
		include		<EEPROM.inc>
		include		<tempo.inc>

			
;************************************************************************
;                			Send_temp									*
;															    		*
;************************************************************************

Send_temp

		bsf		SORTIE_TX
		movlw	.20
		call	delay_1ms				; Bit de start gnral 20ms a 1
	
		movlw	0x55
		call	Write_TX_byte			; Octet de start 0x55
		
		movlw	.2
		call	delay_1ms				; delay entre 2 octets
		
		movf	Temp_Lsb,W
		call	Write_TX_byte			; Emission du Lsb de la temperature
		
		movlw	.2
		call	delay_1ms				; delay entre 2 octets		
		
		movf	Temp_Msb,W
		call	Write_TX_byte			; Emission du Msb de la temperature			
	
		bcf 	SORTIE_TX

	return

;************************************************************************
;                  			Write_TX_byte		           				*
;************************************************************************
	
Write_TX_byte
		movwf	TX_Temp
		movlw	.8
		movwf	Cmpt_TX
		
		bcf		SORTIE_TX
		movlw	.1
		call	delay_1ms				; Bit de start d'octet 1ms a 0
	
Write_TX_byte_1
		rrf		TX_Temp,f
		btfss	STATUS,C
		goto	Write_TX_0
		goto	Write_TX_1
Write_TX_byte_2
		decfsz	Cmpt_TX,f
		goto	Write_TX_byte_1
		bsf		SORTIE_TX
	return
	
Write_TX_0
		bcf		SORTIE_TX
		goto	Maintien
Write_TX_1
		bsf		SORTIE_TX
Maintien
		movlw	.1
		call	delay_1ms
		goto	Write_TX_byte_2	

	END 								; directive fin de programme
