;************************************************************************
;			LCD_Init		Initialisation du module LCD				*
;************************************************************************

LCD_Init
		bcf		RS						; On met a 0 RS pour les commandes
		bcf		E

		movlw	.15
		call   delay_1ms  				; tempo 15 ms

		movlw	0x03
		call	LCD_send_quartet		;	reset

		movlw	.5
		call	delay_1ms
	
		call	LCD_send_quartet		;	2 eme reset
		call	LCD_send_quartet		;	3 eme reset

		movlw	0x02					; Passage en mode 4 bits
		call	LCD_send_quartet

		movlw	0x28					; 4 bits
		call	LCD_Write_Ins

		movlw	0x0C					;Affichage ON [D=1(Affon), C=0(Curseur invisible)
		call	LCD_Write_Ins

		movlw	0x01
		call	LCD_Write_Ins			; Clear display

		movlw	.2
		call   delay_1ms  				; tempo 2 ms

		movlw	0x06
		call	LCD_Write_Ins			; curseur se deplace tout seul

	return								; Initialisation termine
	
;************************************************************************
;	 						 ROUTINES POUR LE LCD						*
;************************************************************************

LCD_Write_Ins
		bcf		RS						; On met a 0 RS pour les instructions
		goto	commun
LCD_Write_ASCII
		addlw	'0'
LCD_Write_car
		bsf		RS						; On met a 1 RS pour les caractres
commun
		movwf	temp
		swapf	temp,w
		andlw	0x0F
		call	LCD_send_quartet		; On envoie le poids fort
		movf	temp,w
		andlw	0x0F
		call	LCD_send_quartet		; Puis le poids faible
	return

LCD_send_quartet
		movwf	LCD_DATA
		call	Valide
		movlw	.10
		call	delay_10u
	return

Valide	
		bsf		E
		nop
		bcf		E
	return

;************************************************************************
;		                      Affich_Temp				                *
;************************************************************************

Affich_Temp

		movlw	'T'
		call	LCD_Write_car

		movlw	'='
		call	LCD_Write_car

		btfsc	Temp_Msb,3
		goto	Temp_neg
	
		movlw	'+'						; Temperature negative
		call	LCD_Write_car
	
		goto	Temp_pos
	
Temp_neg								; Temperature positive
		movlw	'-'
		call	LCD_Write_car
		
		comf	Temp_Msb,f				; Complement a 2 des 2 variables
		incf	Temp_Msb,f
		comf	Temp_Lsb,f
		incf	Temp_Lsb,f
		
Temp_pos

		call	Calcul_int_part			; Calcul de la partie entiere de la temperature
	
		movf	Temp_cent,W				; Centaines
		call	LCD_Write_ASCII
		
		movf	Temp_diz,W				; Dizaines
		call	LCD_Write_ASCII
	
		movf	Temp_unit,W				; Units
		call	LCD_Write_ASCII

		movlw	'.'
		call	LCD_Write_car

		call	Calcul_dec_part			; Calcul de la partie dcimale

		movf	un_sur_2,w				; 2^-1
		call	LCD_Write_ASCII

		movf	un_sur_4,w				; 2^-2
		call	LCD_Write_ASCII

		movf	un_sur_8,w				; 2^-3
		call	LCD_Write_ASCII
	
		movf	un_sur_16,w				; 2^-4
		call	LCD_Write_ASCII

		movlw	0xDF					; caractre degr ""
		call	LCD_Write_car

		movlw	'C'						; Celsius
		call	LCD_Write_car
			
		movlw	0xC0
		call	LCD_Write_Ins			; Retour a la ligne

		movlw	.2
		call	delay_1ms

	return


;************************************************************************
;		                      Affich_nb_mesure				                *
;************************************************************************

Affich_nb_mesure
		
		call	bin_to_dec
		
		movf	Temp_cent,W				; Centaines
		call	LCD_Write_ASCII
		
		movf	Temp_diz,W				; Dizaines
		call	LCD_Write_ASCII
		
		movf	Temp_unit,W				; Units
		call	LCD_Write_ASCII
	
		movlw	'/'
		call	LCD_Write_car
	
		movlw	'1'
		call	LCD_Write_car	
		
		movlw	'2'
		call	LCD_Write_car
	
		movlw	'8'
		call	LCD_Write_car
	
		movlw	0x02
		call	LCD_Write_Ins			; Retour a la 1 ere ligne
	
		movlw	.2
		call	delay_1ms

	return


;************************************************************************
;			                  Calcul_int_part				            *
;************************************************************************

Calcul_int_part
		clrf	dec
	
		rrf		Temp_Msb,f
		rrf		Temp_Lsb,f
		rrf		dec,f
	
		rrf		Temp_Msb,f
		rrf		Temp_Lsb,f
		rrf		dec,f
	
		rrf		Temp_Msb,f
		rrf		Temp_Lsb,f
		rrf		dec,f
	
		rrf		Temp_Msb,f
		rrf		Temp_Lsb,f
		rrf		dec,f					; 4 decalages pour obtenir la partie entire de la temprature dans Temp_Lsb

		swapf	dec,f					; La partie decimale est maintenant dans dec (poids faible)
	
		movf	Temp_Lsb,W

bin_to_dec	
		clrf	Temp_cent
		clrf	Temp_diz
		clrf	Temp_unit
										; Dbut de la procdure de calcul des cantaines/dizaines/units
centaine			
		incf	Temp_cent,f
		addlw	-.100					;W-100->W
		btfsc	STATUS,Z
		goto	final
		btfsc	STATUS,C	
		goto	centaine
		
		addlw	.100
		decf	Temp_cent,f
	
dizaine
		incf	Temp_diz,f
		addlw	-.10					;W-10->W
		btfsc	STATUS,Z
		goto	final
		btfsc	STATUS,C
		goto	dizaine
	
		addlw	.10
		decf	Temp_diz,f

unite
		movwf	Temp_unit
	
final
	return


;************************************************************************
;		                      Calcul_dec_part				            *
;************************************************************************

Calcul_dec_part
		clrf	un_sur_2
		clrf	un_sur_4
		clrf	un_sur_8
		clrf	un_sur_16

		btfsc	dec,3
		call	bit3
		btfsc	dec,2
		call	bit2
		btfsc	dec,1
		call	bit1
		btfsc	dec,0
		call	bit0

		goto	affich_dec	
	
bit3
		movlw	.5
		addwf	un_sur_2,f
	return
bit2
		movlw	.2
		addwf	un_sur_2,f
		movlw	.5
		addwf	un_sur_4,f
	return
bit1
		movlw	.1
		addwf	un_sur_2,f	
		movlw	.2
		addwf	un_sur_4,f
		movlw	.5
		addwf	un_sur_8,f
	return
bit0
		movlw	.6
		addwf	un_sur_4,f	
		movlw	.2
		addwf	un_sur_8,f
		movlw	.5
		addwf	un_sur_16,f
	return

affich_dec
		movf	un_sur_4,w
		addlw	-.10					;W-10->W
		btfss	STATUS,C
		goto	fin_affich_dec			;un_sur_4<10
		movwf	un_sur_4
		incf	un_sur_2,f

fin_affich_dec
	return
