;************************************************************************
;		                     aff_message_flash			                *
;************************************************************************

aff_message_flash
		movlw	0x07
		movwf	high_adresse
		movlw	0xD8	
		movwf	low_adresse
		movlw	.34
		movwf	cmpt_flash
	

aff_char_flash
		call	read_flash
		call	Sortie_RS232
		decfsz	cmpt_flash,f
		goto	continue
	return
	
continue	
		incf	low_adresse,f	
		goto	aff_char_flash

read_flash
		BANK2
		movf	high_adresse,W
		movwf	EEADRH
		movf	low_adresse,W
		movwf	EEADR
		BANK3
		bsf		EECON1,EEPGD
		bsf		EECON1,RD
		BANK2
		nop
		movf	EEDATA,W
		BANK0
	return


;************************************************************************
;		                      aff_temperature			                *
;************************************************************************

aff_temperature
	 	call	aff_1_mesure
	 	decfsz	cmpt_aff,f
	 	goto	aff_temperature 
	 	
	 	movlw	.4
	 	movwf	cmpt_aff
	 	
	 	movlw	0x0D					
		call	Sortie_RS232
		movlw	0x0A
		call	Sortie_RS232
		
		decfsz	cmpt_eeprom,f
		goto	aff_temperature
	 	
	 	movlw	.32
	 	movwf	cmpt_eeprom
	 	clrf	Adresse_eeprom
	 	
	 	movlw	0x0D
		call	Sortie_RS232
		
		movlw	0x0A					; caractre retour chariot
		call	Sortie_RS232
 	
 	return



;************************************************************************
;		                      aff_1_mesure				                *
;************************************************************************

aff_1_mesure
		call	Read_eeprom
		movwf	Temp_Lsb
		incf	Adresse_eeprom,f
		
		call	Read_eeprom
		movwf	Temp_Msb
		incf	Adresse_eeprom,f
	
		movlw	'T'
		call	Sortie_RS232
		
		rrf		Adresse_eeprom,W
		call	bin_to_dec
		
		movf	Temp_cent,W
		call	Sortie_RS232_ASCII
		movf	Temp_diz,W
		call	Sortie_RS232_ASCII
		movf	Temp_unit,W
		call	Sortie_RS232_ASCII
		
		movlw	'='
		call	Sortie_RS232
	
		btfsc	Temp_Msb,3
		goto	Temp_neg
		
		movlw	'+'						; Temperature positive
		call	Sortie_RS232
		
		goto	Temp_pos_RS232
		
Temp_neg_RS232							; Temperature negative
		movlw	'-'
		call	Sortie_RS232
			
		comf	Temp_Msb,f				; Complement a 2 des 2 variables
		incf	Temp_Msb,f
		comf	Temp_Lsb,f
		incf	Temp_Lsb,f
		
Temp_pos_RS232

		call	Calcul_int_part			; Calcul de la partie entiere de la temperature
		
		movf	Temp_cent,W				; Centaines
		call	Sortie_RS232_ASCII
		
		movf	Temp_diz,W				; Dizaines
		call	Sortie_RS232_ASCII
		
		movf	Temp_unit,W				; Units
		call	Sortie_RS232_ASCII
	
		movlw	'.'
		call	Sortie_RS232
	
		call	Calcul_dec_part			; Calcul de la partie dcimale
	
		movf	un_sur_2,w				; 2^-1
		call	Sortie_RS232_ASCII
	
		movf	un_sur_4,w				; 2^-2
		call	Sortie_RS232_ASCII
	
		movf	un_sur_8,w				; 2^-3
		call	Sortie_RS232_ASCII
	
		movf	un_sur_16,w				; 2^-4
		call	Sortie_RS232_ASCII
	
		movlw	0xF8					; caractre degr "" pour la police d'hyperterminal
		call	Sortie_RS232
	
		movlw	'C'						; Celsius
		call	Sortie_RS232
		
		movlw	' '
		call	Sortie_RS232
		
		movlw	' '
		call	Sortie_RS232
		
		movlw	' '
		call	Sortie_RS232
		
	return	
	

;************************************************************************
;		                      Sortie_RS232				                *
;************************************************************************

Sortie_RS232_ASCII
		addlw	0x30
Sortie_RS232
		btfss	PIR1,TXIF
		goto	Sortie_RS232
		movwf	TXREG
	return
