;************************************************************************
;                                                                     	*
;    NOM:				Enregistreur de Temprature, liaison HF			*
;    Date:				Avril 2003                            			*
;    Version:			1.0                                   			*
;    Circuit:			Recepteur										*
;    Auteurs:			JEUFFRAULT/BERRADA 								*	
;                                                                     	*
;************************************************************************
;                                                                     	*
;    Fichier requis: 	P16F870.inc                                    	*
;                    	LCD_recepteur.inc								*
;						RS232.inc										*
;                       tempo.inc                                      	*
;                       EEPROM.inc                                     	*
;************************************************************************
;                                                                     	*
;    Notes:                                                           	*
;                                                                     	*
;************************************************************************


	LIST      p=16F876A          		 ; Dfinition de processeur
	#include <p16F876A.inc>      		 ; Dfinitions des constantes

	__CONFIG   _CP_OFF & _WDT_OFF & _PWRTE_OFF & _LVP_OFF & _BODEN_OFF & _CPD_OFF & _DEBUG_OFF & _XT_OSC

;	_CP_ON		Code protection ON : impossible de relire
;	_CP_OFF		Code protection OFF
;	_PWRTE_ON	Timer reset sur power on en service
;	_PWRTE_OFF	Timer reset hors-service

	ERRORLEVEL	-302					; Supprime le warning de BANK

;************************************************************************
;                              ASSIGNATIONS                          	*
;************************************************************************

;************************************************************************
;	                             DEFINE                                 *
;************************************************************************

;Afficheur
#DEFINE RS			PORTA,3				; Selection du registre afficheur
#DEFINE E			PORTA,5				; Enable
#DEFINE	LCD_DATA	PORTC				; Afficheur LCD

#DEFINE	LED			PORTA,1

;Emetteur
#DEFINE	ENTREE_RX	PORTC,5				; Sortie du module recepteur

;************************************************************************
;	                             MACROS                              	*
;************************************************************************

BANK0	macro	
	bcf		STATUS,RP0
	bcf		STATUS,RP1
	endm

BANK1	macro	
	bsf		STATUS,RP0
	bcf		STATUS,RP1
	endm

BANK2	macro	
	bcf		STATUS,RP0
	bsf		STATUS,RP1
	endm

BANK3	macro	
	bsf		STATUS,RP0
	bsf		STATUS,RP1
	endm

;************************************************************************
;	                   DECLARATIONS DE VARIABLES                        *
;************************************************************************

	CBLOCK 0x20   						; dbut de la zone variables

;compteurs	
	cmpt1			:1				
	cmpt2			:1
	cmpt3 			:1
	Cmpt_RX			:1
	cmpt_flash		:1
	cmpt_eeprom		:1
	cmpt_aff		:1
	
	num_mesure		:1

;variable temporaire
	temp			:1
	TX_Temp			:1
	RX_Byte			:1
	RX_Bit			:1

;temperature
	Temp_Lsb 		:1				
	Temp_Msb 		:1
;partie entiere
	Temp_diz 		:1		
	Temp_cent		:1
	Temp_unit 		:1
;partie decimale
	dec				:1
	un_sur_2		:1
	un_sur_4		:1
	un_sur_8		:1
	un_sur_16		:1
        ENDC							; Fin de la zone   
        
 	CBLOCK 0x70							; Zone commune aux 4 banques
 	high_adresse	:1
	low_adresse		:1
 	Adresse_eeprom	:1

 		ENDC
 	                            

;************************************************************************
;	                      DEMARRAGE SUR RESET                           *
;************************************************************************

	org		0x000	 					; Adresse de dpart aprs reset
  		goto	Main					; Adresse 0: initialiser
	

;************************************************************************
;	                     ROUTINE INTERRUPTION                           *
;************************************************************************

	org 	0x004						; adresse d'interruption
	
		clrf	RCREG
	
		clrf	Adresse_eeprom	
		clrf	num_mesure
	
		bsf		LED

		BANK1
		bsf		TXSTA,TXEN				; active la l'emission srie
		BANK0
	
		call	aff_message_flash		; Envoi le message d'accueil
		call	aff_temperature			; Affiche les temperature en quatre colonnes
		
		BANK1
		bcf		TXSTA,TXEN				; Dsactive l'emission srie
		BANK0	
	
		bcf		LED		
	
		clrf	Adresse_eeprom
	
		retfie


;************************************************************************
;	                       INITIALISATIONS DU PIC                       *
;************************************************************************

Init
		BANK0

		clrf	PORTA					; Sorties portA  0

		BANK1
	
		clrf	TRISA					; PortA en sortie		

		movlw	0x06
		movwf	ADCON1					; entres sorties numriques
	
		clrf	TRISB					; portB en sortie

		movlw	0xA0
		movwf	TRISC					; portC ..

		movlw	0x87		 			; charger masque
		movwf	OPTION_REG				; initialiser registre option pull up off prescaler 256 sur Timer0

		movlw	0x20					; Interruption sur USART receive
		movwf	PIE1
	
		movlw	.12						; liaison a 19200 bauds
		movwf	SPBRG
	
		movlw	0x06					; Liaison High speed Asynchrone
		movwf	TXSTA
		
		BANK0
	
		movlw	0x90					; Transmission srie active et reception continue
		movwf	RCSTA
		
		movlw	0x40					; masque interruption
		movwf	INTCON					; Interruptions peripheriques active
	
		clrf	PORTB				
		clrf	PORTC				

			; Effacer RAM
			
		movlw	0x20					; initialisation pointeur
		movwf	FSR						; pointeur d'adressage indirec
Init1
		clrf	INDF					; effacer ram
		incf	FSR,f					; pointer sur suivant
		btfss	FSR,7					; tester si fin zone atteinte (>=7F)
		goto	Init1					; non, boucler

		BANK3
		bsf		EECON1,WREN				; Autoriser ecriture EEPROM
		BANK0

 		movlw	.4
 		movwf	cmpt_aff				; Affichage sur hyperterminal en 4 colonnes

 		movlw	.32						; 32*4=128 temperatures
 		movwf	cmpt_eeprom			

		clrf	Adresse_eeprom	
		clrf	num_mesure
	
		bsf		INTCON,GIE	; valider interruptions

		return

;************************************************************************
;	                      PROGRAMME PRINCIPAL                        	*
;************************************************************************

Main
		call	Init					; Initialisation PIC
		call	LCD_Init				; Initialisation LCD 4 bits
Main1
		btfss	ENTREE_RX
		goto	Main1
		clrf	TMR0
Bit_Start
		btfsc	ENTREE_RX
		goto	Bit_Start
		movf	TMR0,W
		addlw	-.75					; 75*256 s correspond a envion 20ms du bit de start
		btfsc	STATUS,Z
		goto	Reception_start
		btfss	STATUS,C
		goto	Main1					; < a 75*256 s
		
Reception_start							; >= a 75*256 s 	
		movlw	.50
		call	delay_10u
		
		btfsc	ENTREE_RX				; bit de start a 0 ?
		goto	Main1					; non
		
		call	Read_TX_Byte			; lecture de l'octet de start 0x55=85
		movf	RX_Byte,W
		
		addlw	-.85
		btfss	STATUS,Z
		goto	Main1					;	Octet de start non conforme
		
		bsf		LED						;	Octet de start	conforme
	
		movlw	.1
		call	delay_1ms

		call	Attente_Bit_Start		; Attente du bit de start a 0
	
		movlw	.50
		call	delay_10u
		
		btfsc	ENTREE_RX				; verif a la moiti
		goto	Main1
		
		call	Read_TX_Byte			; lecture 1er octet
		movf	RX_Byte,W
		movwf	Temp_Lsb
		
		movlw	.1
		call	delay_1ms
		
		call	Attente_Bit_Start		; Attente du bit de start a 0

		movlw	.50
		call	delay_10u
		
		btfsc	ENTREE_RX
		goto	Main1
		
		call	Read_TX_Byte			; lecture 2eme octet
		movf	RX_Byte,W
		movwf	Temp_Msb
			
		call	Write_Temp_eeprom		; sauvegarde de la temperature dans l'EEPROM
		movf	Adresse_eeprom,f
		btfss	STATUS,Z				; on revient au debut si on a deja ecrit 256 octets
		clrf	Adresse_eeprom
		
		call	Affich_Temp				; Affichage de la temperature sur le LCD

		incf	num_mesure,f
		movf	num_mesure,W
		
		call	Affich_nb_mesure		; Affichage du nombre de mesure sur le LCD
		
		bcf		LED
		
		goto	Main1
		
		
Attente_Bit_Start
		btfsc	ENTREE_RX
		goto	Attente_Bit_Start	
		return	
		
;************************************************************************
;          				Read_TX_Byte & Read_TX_Bit	           			*
;************************************************************************		
		

Read_TX_Byte
		movlw	.8
		movwf	Cmpt_RX
Read_TX_Byte_1
		call	Read_TX_Bit
		rrf		RX_Bit,f
		rrf		RX_Bit,f
		rrf		RX_Bit,f
		rrf		RX_Bit,f		
		rrf		RX_Bit,f
		rrf		RX_Bit,f		
		rrf		RX_Byte,f
		decfsz	Cmpt_RX,f
		goto	Read_TX_Byte_1
		return

Read_TX_Bit
		movlw	.1
		call	delay_1ms
		movf	PORTC,W
		movwf	RX_Bit
		return



		include	<LCD_recepteur.inc>
		include	<RS232.inc>
		include	<tempo.inc>
		include	<EEPROM.inc>


;************************************************************************
;	             INITIALISATION D'UNE ZONE MEMOIRE FLASH				*
;************************************************************************

	Org	0x07D8
	DA	0x50,0x20,'R','e','l','e','v','e',' ','d','e','s',' ','p','r','i','s','e','s',' ','d','e',' ','t','e','m','p','e','r','a','t','u','r','e',0x0D,0x0A

	END 								; directive fin de programme
