/*-----------------------------------------------------------
 * Enable/Disable interrupt macro
 *----------------------------------------------------------*/
#ifndef __MCF5213_INT_H__
#define __MCF5213_INT_H__

#define  mcf5xxx_irq_disable()       \
    __asm__ __volatile__  ( "MOVE.L  %d0,-(%a7) \n\t"   \
                            "MOVE.W  %sr, %d0   \n\t"   \
                            "ORI.L   #0x0700,%d0  \n\t" \
                            "MOVE.W  %d0, %sr  \n\t"    \
                            "MOVE.L  (%a7)+, %d0 \n\t"  \
                                  ) 


#define mcf5xxx_irq_enable()         \
	__asm__ __volatile__ (  " MOVE.L  %d0,-(%a7) \n\t"   \
			                " MOVE.W  %sr, %d0   \n\t"   \
			                " ANDI.L  #0xF0FF,%d0 \n\t"  \
			                " MOVE.W  %d0, %sr    \n\t"  \
			                " MOVE.L  (%a7)+, %d0  "     \
			             )  
                            
#endif


