/*
 * File:    m5211demo.c
 * Purpose: Board specific routines
 *
 * Notes:   
 */
#include "m5211demo.h"
#include "common.h"
//#include <stdio.h>
#include "clock/clock.h"

/********************************************************************/

/********************************************************************/
/*
 * System Initialization
 * Called by asm_startmeup (mcf5213_lo.s)
 */

int sys_clk_khz = SYS_CLK_KHZ;

void
board_sysinit (void)

/* Actual system clock frequency */

{
    /* Initialize the PLL */
    if (REF_CLK_KHZ == SYS_CLK_KHZ)
        clock_pll(REF_CLK_KHZ, SYS_CLK_KHZ, PLL_DISABLE);
    else
        clock_pll(REF_CLK_KHZ, SYS_CLK_KHZ, 0);

    /* Enable the proper UART pins */
    switch (TERMINAL_PORT)
    {
        case 0:
        default:
            MCF_GPIO_PUAPAR = 0
                | MCF_GPIO_PUAPAR_RXD0_RXD0
                | MCF_GPIO_PUAPAR_TXD0_TXD0;
    }
 
  /* 
  * Allow interrupts from SW1 and SW2 (IRQ[4,7]) 
  */
     
    /* Enable IRQ signals on the port */
    MCF_GPIO_PNQPAR = 0
        | MCF_GPIO_PNQPAR_IRQ4_IRQ4
        | MCF_GPIO_PNQPAR_IRQ7_IRQ7;
    
    /* Set EPORT to look for rising edges */
    MCF_EPORT_EPPAR = 0
        | MCF_EPORT_EPPAR_EPPA4_RISING
        | MCF_EPORT_EPPAR_EPPA7_RISING;
        
    /* Clear any currently triggered events on the EPORT */
    MCF_EPORT_EPIER = 0
        | MCF_EPORT_EPIER_EPIE4
        | MCF_EPORT_EPIER_EPIE7;
        
    /* Enable interrupts in the interrupt controller */
    MCF_INTC_IMRL &= ~(0
        | MCF_INTC_IMRL_MASK4 
        | MCF_INTC_IMRL_MASK7 
        | MCF_INTC_IMRL_MASKALL);

}
/********************************************************************/
/*
 * Pause for the specified number of micro-seconds.
 * Uses DTIM3 as a timer
 */
void
cpu_pause(int usecs)
{
    /* Enable the DMA Timer 3 */
    MCF_DTIM3_DTRR = (usecs - 1);
    MCF_DTIM3_DTER = MCF_DTIM_DTER_REF;
    MCF_DTIM3_DTMR = 0
        | MCF_DTIM_DTMR_PS(sys_clk_khz / 1000)
        | MCF_DTIM_DTMR_ORRI
        | MCF_DTIM_DTMR_FRR
        | MCF_DTIM_DTMR_CLK_DIV1
        | MCF_DTIM_DTMR_RST;

    while ((MCF_DTIM3_DTER & MCF_DTIM_DTER_REF) == 0) 
    {};
    
    /* Disable the timer */
    MCF_DTIM3_DTMR = 0;
}
/********************************************************************/
/* 
 * Display the lower 4 bits of 'number' on the 4 LEDs connected to 
 * TIN[3:0]
 *
 *  LED: LED4 LED3 LED2 LED1
 *  PIN: TIN3 TIN2 TIN1 TIN0
 *  BIT:    3    2    1    0
 */
void
board_led_display(int number)
{
    /* Enable signals as GPIO */
    MCF_GPIO_PTCPAR = 0
        | MCF_GPIO_PTCPAR_TIN3_GPIO
        | MCF_GPIO_PTCPAR_TIN2_GPIO
        | MCF_GPIO_PTCPAR_TIN1_GPIO
        | MCF_GPIO_PTCPAR_TIN0_GPIO;
    
    /* Set output values */
    MCF_GPIO_PORTTC = (uint8)number;
    
    /* Enable signals as digital outputs */
    MCF_GPIO_DDRTC = 0
        | MCF_GPIO_DDRTC_DDRTC3
        | MCF_GPIO_DDRTC_DDRTC2
        | MCF_GPIO_DDRTC_DDRTC1
        | MCF_GPIO_DDRTC_DDRTC0;
}
/********************************************************************/
