/*
 * File:        m5211demo.h
 * Purpose:     Evaluation board definitions and memory map information
 *
 * Notes:
 */

#ifndef __M5211EVB_H__
#define __M5211EVB_H__

/********************************************************************/
// !!!! dfini aussi dans FreeRTOSConfig.h !!!! 
#define REF_CLK_MHZ         (8)
#define REF_CLK_KHZ         (8000)
#define SYS_CLK_MHZ         (48)
#define SYS_CLK_KHZ         (48000)
 
extern int sys_clk_khz;
extern int sys_clk_mhz;

/* Serial Port Info */
#define TERMINAL_PORT       (0)
#define TERMINAL_BAUD       (19200)
#undef  HW_FLOW_CONTROL

/* 
 * Memory map definitions from linker command files 
 */
//extern uint8 __IPSBAR[]= 0x40000000;
//extern uint8 __SRAM[]= 0x20000000;
//extern uint8 __SRAM_SIZE[]= (16 * 1024);
//extern uint8 __FLASH[]= 0x00000000;
//extern uint8 __FLASH_SIZE[]= (128 * 1024);

#define __IPSBAR ((vuint8 *) 0x40000000) 
#define __SRAM   ((vuint8 *) 0x20000000) 
#define __SRAM_SIZE ( (32 * 1024))
#define __FLASH  ((vuint8 *) 0x00000000 ) 
#define __FLASH_SIZE ( (256 * 1024) )  


/* 
 * Memory Map Info 
 */
#define IPSBAR_ADDRESS      (uint32)__IPSBAR

#define SRAM_ADDRESS        (uint32)__SRAM
#define SRAM_SIZE           (uint32)__SRAM_SIZE

#define FLASH_ADDRESS       (uint32)__FLASH
#define FLASH_SIZE          (uint32)__FLASH_SIZE

/*
 * Board specific function prototypes
 */ 
void board_sysinit (void);
void board_handle_interrupt (int);
void board_led_display (int);

/********************************************************************/

#endif /* __M5211EVB_H__ */
