/*
 * File:		main.c
 * Purpose:		Main process
 *
 */
#include "../../FreeRTOS4p7/include/FreeRTOS.h"
#include "../../FreeRTOS4p7/include/task.h"

#include "common.h"

/*
*******************************************************************************
*
* TASK 1
*
*******************************************************************************
*/
static void vTask( void *pvParameters )
{		
	for( ;; )
	{
		board_led_display(0x01); // insert your code here
		vTaskDelay(600);         // insert your code here
	}
}
/*
*******************************************************************************
*
* TASK 2
*
*******************************************************************************
*/
void vTaskTwo ( void *pvParameters )
{
	for (;;)
	{
		board_led_display(0x04);  // insert your code here
		vTaskDelay(200);          // insert your code here
	}
}

/*
**********************************************************************/
void vApplicationIdleHook( void )
{   int j=0;
    j++;
	for ( ;; )    ;
}

/********************************************************************/
int 
main (void)
{
	board_sysinit ();
    mcf5xxx_irq_enable() ;
    
    /* Initialize the CRTL1 register to all 0's */
    MCF_ADC_CTRL1 = 0;  
    
    /* Setting divisor in CTRL2 register */
    MCF_ADC_CTRL2 = MCF_ADC_CTRL2_DIV(3);
    
    /* Setting PortAN Pin 0 as ADC functionality */
    MCF_GPIO_PANPAR |= MCF_GPIO_PANPAR_PANPAR0;
    
    /* Setting Power Register appropriately */
    MCF_ADC_POWER = MCF_ADC_POWER_PUDELAY(2);

	
	/* Set SMODE to "Loop Sequential" */
	MCF_ADC_CTRL1 |= MCF_ADC_CTRL1_SMODE(2);
	
	/* Set start bit */
	MCF_ADC_CTRL1 |= MCF_ADC_CTRL1_START0;
	
	/* Below is the code for the loop that keeps the LEDs toggling 
		indefinitely.
	*/
     
	if (xTaskCreate( vTask,   (const signed char *)"MyTask",  configMINIMAL_STACK_SIZE  , NULL, ( tskIDLE_PRIORITY + 1 ), NULL ) == pdFAIL)
	{
		for (;;)	asm ("nop");
	}

	if (xTaskCreate( vTaskTwo, (const signed char *)"MyTaskTwo", configMINIMAL_STACK_SIZE*2, NULL, ( tskIDLE_PRIORITY + 2 ), NULL ) == pdFAIL)
	{		
		for (;;)	asm ("nop");
	}

	/* All the tasks have been created - start the scheduler. */
	vTaskStartScheduler();	
	
	/* Should not reach here! */
	for( ;; );


return 0 ; }


/********************************************************************/

void __attribute__ ((interrupt)) __cs3_isr_interrupt_68(void) //IQR[4]
{ int i=0;
MCF_EPORT_EPFR=0xFF ; // Edge port int. flag clearing
i++;
board_led_display(0xff);
cpu_pause(200000);
}

void __attribute__ ((interrupt)) __cs3_isr_interrupt_71(void) //IQR[7]
{ int j=0;
MCF_EPORT_EPFR=0xFF ; // Edge port int. flag clearing
j++;
board_led_display(0xff);
cpu_pause(200000);
}

