'****************************************************************
'*  Name    : H_LED3.BAS                                        *
'*  Auteur  : Grard                                            *
'*  Date    : 	                                                *
'*  Version : 2.0                                               *
'*  Notes   : La version 3 ne sera pas utilise pour l'instant  *
'*          :                                                   *
'****************************************************************
		
;Un Qz de 3,2768 MHz fait tourner le PIC, cette valeur entre aussi dans TMR1

;Version 1 : utilisation de LED tricolores
;-----------------------------------------
		
;Version 1.1 : modif affectation des I/O
;---------------------------------------
		
;Version 2 : utilisation de LED d'une seule couleur
;--------------------------------------------------
		
;3e essai :
;	on utilisera des LED diffrentes pour les h/mn/s
;	h : bleues, mn : blanches, s : rouges
		
;Version 3 : ajout de la mesure de temprature par LM335
;-------------------------------------------------------
		
;la 1re version PCB sera cable sans mesure de temprature (TL335 et TL431)
		
;Version publie : V2
		
;Affectation des broches du 16F877
;---------------------------------
		
;	1   MCLR	R/C		   40	B7
;	2   A0				   39	B6	
;	3   A1 				   38	B5	HD1
;       4   A2				   37	B4	HD2
;       5   A3			   	   36	B3	HU1
;       6   A4				   35	B2	HU2
;       7   A5				   34	B1	HU4
;       8   E0		BP_PLUS	  	   33	B0 	HU8
;       9   E1				   32	VDD
;       10  E2				   31	VSS
;       11  VDD				   30	D7	MD4
;	12  VSS				   29	D6	MD2
;       13  QZ				   28	D5	MD1
;       14  QZ				   27	D4	MU1
;       15  C0				   26	C7	MU2
;       16  C1		BP_OK		   25   C6	MU4
;       17  C2		SU1		   24   C5	MU8
;       18  C3		SU2		   23   C4	SD4
;       19  D0		SU4		   22   D3	SD2
;       20  D1		SU8		   21   D2	SD1
		
;Explications :
	;	HD : Heures Dizaines
	;	HU : Heures Units
	;	MD : Minutes Dizaines
	;	MU : Minutes Units
	;	SD : Secondes Dizaines
	;	SU : Secondes Units
		
;Les chiffres reprsentent le "poids" binaire
		
;Fonctionnement:
;---------------
		
;A la mise sous tension, l'affichage est 1h, 1min, 1s
;le comptage de l'heure commence
		
;Pour la mise  l'heure :
;------------------------
		
;	- appui sur BP_OK
;	- si BP_PLUS est appuy, il y a incrmentation des heures
;	- si la bonne huere est affiche, relacher BP_PLUS (si trop tard,
;	  le comptage repasse  0 aprs 23h)
;	- valider l'affichage des heures par appui sur BP_OK
;	  ceci permet de rentrer dans la procdure de rglage des minutes
;	- le rglage des minutes est identique  celui des heures
;	-  la fin du rglage des minutes, appuyer sur BP_OK
;	  pour valider l'affichage de l'heure
		
;Sur la carte, BP_PLUS se trouve  gauche et donc BP_OK  droite
		
;Les rsistances de limitation pour les LED ont t choisies par essais
;de luminosit des LED en ma possession
;	bleues   : 120 ohm
;	blanches : 470 ohm
;	rouges   : 330 ohm
		
;Les rsistances pour les BP et MCLR : 10K
;Le quartz est un modle 3,2768MHz valeur qui est aussi prise en compte par TMR1

;*************************************************************
;		DEFINITION DU PROCESSEUR
;*************************************************************
		
		Device = 16F877A

;*************************************************************
;		MOT DE CONFIGURATION
;*************************************************************
		
		Config   CP_OFF, DEBUG_OFF, WRT_OFF, CPD_OFF, LVP_OFF, BODEN_OFF, PWRTE_ON, WDT_OFF, XT_OSC
	
		
;*************************************************************
;		DECLARATIONS + SYMBOLES
;*************************************************************
		
		Symbol 	BP_PLUS	=	PORTE.0
		Symbol 	BP_OK	=	PORTC.1
		
;*************************************************************
;		VARIABLES
;*************************************************************
		
		Dim	HR		As Byte
		Dim	MN		As Byte
		Dim 	SEC		As Byte
		
		Dim	HR_DIZ		As Byte
		Dim	MN_DIZ		As Byte
		Dim	SEC_DIZ		As Byte
		
		Dim	HR_UNIT		As Byte
		Dim	MN_UNIT		As Byte
		Dim	SEC_UNIT	As Byte	
		
		Dim	MSB_DIZ		As Byte
		Dim	NSB_DIZ		As Byte
		Dim	LSB_DIZ		As Byte
		
		Dim	MSB_UNIT	As Byte
		Dim	NSB_UNIT	As Byte
		Dim	LSB_UNIT	As Byte	
		
		Dim	RAM_INTER	As Byte
		Dim	i		As Byte
		
;*************************************************************
;		MACROS ASSEMBLEUR
;*************************************************************
		
		#include "macros.asm"
		
;*************************************************************
;		SAUT VERS INTERRUPTION TIMER1
;*************************************************************
		
on_interrupt	IRQ_TMR1
		
;*************************************************************
;		DEBUT DU PROGRAMME PRINCIPAL
;*************************************************************
		
		GoTo	INIT
		
;*************************************************************
;		ROUTINE D'INTERRUPTION DU TIMER1
;*************************************************************		
		
IRQ_TMR1:

		ASM
		bcf		PIR1,TMR1IF			;flag irq TMR1 = 0
		bsf     	TMR1H,7   			;rechargement TMR1 080h
		
		incf		RAM_INTER,f
		cljne		25,RAM_INTER,RESTORER_CONTEXTE
		clrf		RAM_INTER
		
		incf		SEC,f				;seconde + 1
	 	cljne		60,SEC,RESTORER_CONTEXTE
		clrf		SEC
	 	
		incf		MN,f
		cljne		60,MN,RESTORER_CONTEXTE
		clrf		MN
		
		incf		HR,f
		cljne		24,HR,RESTORER_CONTEXTE
		clrf		HR
		ENDASM
		
RESTORER_CONTEXTE:
		
		Context Restore
		
;*************************************************************
;		INITIALISATIONS
;*************************************************************
		 
INIT:
		
		PORTA	= 0
		PORTB	= 0
		PORTC	= 0
		PORTD 	= 0
		PORTE	= 0
		
		PIR1	= 0
		PIR2	= 0
		OPTION_REG = %11010000
		INTCON	= %01000000			;GIE = 0, PEIE = 1
		PIE1	= 1				;TMR1IE = 1
		
		TMR1L	= 0
		TMR1H	= %10000000			;128
		T1CON	= %00000001			;QZ = 3,2768 MHz
		T2CON	= 0
		CCP1CON	= 0
		CCP2CON	= 0
		EECON1	= 0
		
		TRISA	= 0
		TRISB	= 0
		TRISC	= %00000010            		;C1 : entre BP_OK
		TRISD	= 0
		TRISE	= %001		 		;E0 : entre BP_PLUS
        		
		ADCON1 = 7	       			;pas d'entre ana
		INTCON.7 = 1				;GIE = 1
		
		RAM_INTER = 0
		HR	= 1
		MN	= 1
		SEC 	= 1
						
;*************************************************************
;		PROGRAMME PRINCIPAL
;*************************************************************
		
BOUCLE_PRINCIPALE:
		
		GoSub CONV_H
		GoSub AFF_HEURE
        	
		If BP_OK = 1 Then BOUCLE_PRINCIPALE     ;boucle si BP non appuy
		GoSub MISE_A_HEURE                      ;SP si BP appuy
		GoTo BOUCLE_PRINCIPALE
		
;*************************************************************
;		SOUS PROGRAMME MISE A L'HEURE
;*************************************************************
		
MISE_A_HEURE:	
		
		INTCON.7 = 0     			;GIE = 0
		SEC	 = 0				;init SEC
		
		If BP_OK = 0 Then MISE_A_HEURE          ;attente relachement BP_OK
		
HEURES:		
		While BP_PLUS = 0			;tant que BP appuy
			HR = HR + 1
			If HR >= 24 Then HR = 0
			GoSub CONV_H	
			GoSub AFF_HEURE
			DelayMS  500
		Wend
		DelayMS	200
		
		If BP_OK = 1 Then HEURES                ;attente validation par BP_OK
		
MINUTES:	
		If BP_OK = 0 Then MINUTES		;attente relachement BP_OK
		
		While BP_PLUS = 0
			MN = MN + 1
			If MN >= 60 Then MN = 0
			GoSub CONV_H
			GoSub AFF_HEURE
			DelayMS  500
		Wend
		DelayMS	200
		
		If BP_OK = 1 Then MINUTES		;si BP relach --> on boucle
		DelayMS	1000
  		
		RAM_INTER = 0
		SEC	  = 1
		TMR1L	  = 0
		TMR1H 	  = %10000000			;080h
		INTCON.7  = 1
		
		Return
		
;*************************************************************
;		SOUS PROGRAMME CONVERSION DE L'HEURE
;*************************************************************
		
;entre : 3 octets comprenant les h, mn et s en binaire
;sortie : 6 octets comprenant les h, mn et s en dizaines et units
		
CONV_H:		
		
		HR_DIZ = 0				;init HR_DIZ
		HR_UNIT = HR				;transfert donne
		
		While HR_UNIT >= 10			;tant que unit >= 10
			HR_UNIT = HR_UNIT - 10		;unit - 10
			HR_DIZ = HR_DIZ + 1		;dizaine + 1
		Wend
		
		MN_DIZ = 0				;init MN_DIZ
		MN_UNIT = MN				;transfert donne
		
		While MN_UNIT >= 10			;tant que unit >= 10
			MN_UNIT = MN_UNIT - 10		;unit - 10
			MN_DIZ = MN_DIZ + 1		;dizaine + 1
		Wend
		
		SEC_DIZ = 0				;init SEC_DIZ
		SEC_UNIT = SEC				;transfert donne
		
		While SEC_UNIT >= 10			;tant que unit >= 10
			SEC_UNIT = SEC_UNIT - 10	;unit - 10
			SEC_DIZ = SEC_DIZ + 1		;dizaine + 1
		Wend
		
		Return
		
;*************************************************************
;		SOUS PROGRAMME AFFICHAGE HEURE
;*************************************************************
		
AFF_HEURE:	
		
		Select HR_DIZ
			Case 0  
				PORTB.5 = 0 
				PORTB.4 = 0
				
			Case 1
				PORTB.5 = 1
				PORTB.4 = 0
			Case 2
				PORTB.5 = 0
				PORTB.4 = 1
		EndSelect
		
		Select HR_UNIT
			Case 0
				PORTB.3 = 0
				PORTB.2 = 0
				PORTB.1 = 0
				PORTB.0 = 0
				
			Case 1
				PORTB.3 = 1
				PORTB.2 = 0
				PORTB.1 = 0
				PORTB.0 = 0
			Case 2
				PORTB.3 = 0
				PORTB.2 = 1
				PORTB.1 = 0
				PORTB.0 = 0
			Case 3
				PORTB.3 = 1
				PORTB.2 = 1
				PORTB.1 = 0
				PORTB.0 = 0
			Case 4
				PORTB.3 = 0
				PORTB.2 = 0
				PORTB.1 = 1
				PORTB.0 = 0
			Case 5
				PORTB.3 = 1
				PORTB.2 = 0
				PORTB.1 = 1
				PORTB.0 = 0
			Case 6
				PORTB.3 = 0
				PORTB.2 = 1
				PORTB.1 = 1
				PORTB.0 = 0
			Case 7
				PORTB.3 =  1
				PORTB.2 =  1
				PORTB.1 =  1
				PORTB.0 =  0
			Case 8
				PORTB.3 =  0
				PORTB.2 =  0
				PORTB.1 =  0
				PORTB.0 =  1
			Case 9
				PORTB.3 =  1
				PORTB.2 =  0
				PORTB.1 =  0
				PORTB.0 =  1
                EndSelect
                
		Select MN_DIZ
			Case 0  
				PORTD.5 = 0 
				PORTD.6 = 0
				PORTD.7 = 0
			Case 1
				PORTD.5 = 1
				PORTD.6 = 0
				PORTD.7 = 0
			Case 2
				PORTD.5 = 0
				PORTD.6 = 1
				PORTD.7 = 0
			Case 3
				PORTD.5 = 1
				PORTD.6 = 1
				PORTD.7 = 0
			Case 4
				PORTD.5 = 0
				PORTD.6 = 0
				PORTD.7 = 1
			Case 5
				PORTD.5 = 1
				PORTD.6 = 0
				PORTD.7 = 1
		EndSelect
		
		Select MN_UNIT
			Case 0
				PORTD.4 = 0
				PORTC.7 = 0
				PORTC.6 = 0
				PORTC.5 = 0
				
			Case 1
				PORTD.4 = 1
				PORTC.7 = 0
				PORTC.6 = 0
				PORTC.5 = 0
			Case 2
				PORTD.4 = 0
				PORTC.7 = 1
				PORTC.6 = 0
				PORTC.5 = 0
			Case 3
				PORTD.4 = 1
				PORTC.7 = 1
				PORTC.6 = 0
				PORTC.5 = 0
			Case 4
				PORTD.4 = 0
				PORTC.7 = 0
				PORTC.6 = 1
				PORTC.5 = 0
			Case 5
				PORTD.4 = 1
				PORTC.7 = 0
				PORTC.6 = 1
				PORTC.5 = 0
			Case 6
				PORTD.4 = 0
				PORTC.7 = 1
				PORTC.6 = 1
				PORTC.5 = 0
			Case 7
				PORTD.4 = 1
				PORTC.7 = 1
				PORTC.6 = 1
				PORTC.5 = 0
			Case 8
				PORTD.4 = 0
				PORTC.7 = 0
				PORTC.6 = 0
				PORTC.5 = 1
			Case 9
				PORTD.4 = 1
				PORTC.7 = 0
				PORTC.6 = 0
				PORTC.5 = 1
		EndSelect
		
		Select SEC_DIZ
			Case 0  
				PORTD.2 = 0 
				PORTD.3 = 0
				PORTC.4 = 0
			Case 1
				PORTD.2 = 1
				PORTD.3 = 0
				PORTC.4 = 0
			Case 2
				PORTD.2 = 0
				PORTD.3 = 1
				PORTC.4 = 0
			Case 3
				PORTD.2 = 1
				PORTD.3 = 1
				PORTC.4 = 0
			Case 4
				PORTD.2 = 0
				PORTD.3 = 0
				PORTC.4 = 1
			Case 5
				PORTD.2 = 1
				PORTD.3 = 0
				PORTC.4 = 1
		EndSelect
		
		Select SEC_UNIT
			Case 0
				PORTC.2 = 0
				PORTC.3 = 0
				PORTD.0 = 0
				PORTD.1 = 0
				
			Case 1
				PORTC.2 = 1
				PORTC.3 = 0
				PORTD.0 = 0
				PORTD.1 = 0
			Case 2
				PORTC.2 = 0
				PORTC.3 = 1
				PORTD.0 = 0
				PORTD.1 = 0
			Case 3
				PORTC.2 = 1
				PORTC.3 = 1
				PORTD.0 = 0
				PORTD.1 = 0
			Case 4
				PORTC.2 = 0
				PORTC.3 = 0
				PORTD.0 = 1
				PORTD.1 = 0
			Case 5
				PORTC.2 = 1
				PORTC.3 = 0
				PORTD.0 = 1
				PORTD.1 = 0
			Case 6
				PORTC.2 = 0
				PORTC.3 = 1
				PORTD.0 = 1
				PORTD.1 = 0
			Case 7
				PORTC.2 = 1
				PORTC.3 = 1
				PORTD.0 = 1
				PORTD.1 = 0
			Case 8
				PORTC.2 = 0
				PORTC.3 = 0
				PORTD.0 = 0
				PORTD.1 = 1
			Case 9
				PORTC.2 = 1
				PORTC.3 = 0
				PORTD.0 = 0
				PORTD.1 = 1
		EndSelect
		
		Return
		
		End
		
