/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

class MaterialNode
extends DefaultMutableTreeNode {
    String family;
    String name;
    double elasticModulus;
    double poissonsRatio;
    double shearModulus;
    double density;
    double tensileStrength;
    double yieldStrength;
    double compressiveStrength;

    MaterialNode(Vector values) {
        this.family = (String)values.get(0);
        this.name = (String)values.get(1);
        String elasticModulusStr = (String)values.get(2);
        String poissonsRatioStr = (String)values.get(3);
        String shearModulusStr = (String)values.get(4);
        String densityStr = (String)values.get(5);
        String tensileStrengthStr = (String)values.get(6);
        String yieldStrengthStr = (String)values.get(7);
        String compressiveStrengthStr = (String)values.get(8);
        try {
            this.elasticModulus = elasticModulusStr == "" ? Double.NaN : Double.parseDouble(elasticModulusStr);
            this.poissonsRatio = poissonsRatioStr == "" ? Double.NaN : Double.parseDouble(poissonsRatioStr);
            this.shearModulus = shearModulusStr == "" ? Double.NaN : Double.parseDouble(shearModulusStr);
            this.density = densityStr == "" ? Double.NaN : Double.parseDouble(densityStr);
            this.tensileStrength = tensileStrengthStr == "" ? Double.NaN : Double.parseDouble(tensileStrengthStr);
            this.yieldStrength = yieldStrengthStr == "" ? Double.NaN : Double.parseDouble(yieldStrengthStr);
            this.compressiveStrength = compressiveStrengthStr == "" ? Double.NaN : Double.parseDouble(compressiveStrengthStr);
        }
        catch (NumberFormatException e) {
            System.out.println("Warning, incorrect material value.\n" + e.getMessage());
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean equals(MaterialNode m) {
        return m.name.equals(this.name) && m.family.equals(this.family);
    }
}

